/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger;

import com.aptana.php.debug.core.preferences.PHPDebugPreferencesUtil;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org2.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;
import org2.eclipse.php.internal.debug.ui.preferences.AbstractDebuggerConfigurationDialog;

public class ZendDebuggerConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    private Text fDebugTextBox;
    private Button fRunWithDebugInfo;
    private Text fClientIP;
    private ZendDebuggerConfiguration zendDebuggerConfiguration;
    private int originalPort;

    public ZendDebuggerConfigurationDialog(ZendDebuggerConfiguration zendDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.zendDebuggerConfiguration = zendDebuggerConfiguration;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = (Composite)super.createDialogArea(parent);
        this.setTitle(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebuggerSettings);
        Composite composite = this.createSubsection(parent, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebugger);
        this.addLabelControl(composite, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, "com.aptana.php.debug.eplzend_debug_port");
        this.fDebugTextBox = this.addTextField(composite, "com.aptana.php.debug.eplzend_debug_port", 6, 2);
        GridData gridData = (GridData)this.fDebugTextBox.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.fDebugTextBox.addModifyListener((ModifyListener)new DebugPortValidateListener());
        this.fRunWithDebugInfo = this.addCheckBox(composite, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_runWithDebugInfo, "com.aptana.php.debug.eplrun_with_debug_info", 0);
        this.addLabelControl(composite, "Client Host/IP:", "com.aptana.php.debug.eplclient_ip");
        this.fClientIP = this.addTextField(composite, "com.aptana.php.debug.eplclient_ip", 0, 2);
        gridData = (GridData)this.fClientIP.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.internalInitializeValues();
        return composite;
    }

    private void internalInitializeValues() {
        this.fRunWithDebugInfo.setSelection(PHPDebugPreferencesUtil.getBoolean("com.aptana.php.debug.eplrun_with_debug_info", true));
        this.originalPort = PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.eplzend_debug_port", 10000);
        this.fDebugTextBox.setText(Integer.toString(this.originalPort));
        this.fClientIP.setText(PHPDebugPreferencesUtil.getString("com.aptana.php.debug.eplclient_ip", "127.0.0.1"));
    }

    protected void okPressed() {
        IEclipsePreferences preferences = PHPDebugEPLPlugin.getInstancePreferences();
        preferences.putBoolean("com.aptana.php.debug.eplrun_with_debug_info", this.fRunWithDebugInfo.getSelection());
        preferences.put("com.aptana.php.debug.eplzend_debug_port", this.fDebugTextBox.getText());
        preferences.put("com.aptana.php.debug.eplclient_ip", this.fClientIP.getText());
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
        super.okPressed();
    }

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.php.debug.epl.zend_conf");
    }

    class DebugPortValidateListener
    implements ModifyListener {
        DebugPortValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            Integer iValue;
            String errorMessage = null;
            boolean valid = true;
            String value = ((Text)e.widget).getText();
            try {
                iValue = new Integer(value);
                int i = iValue;
                if (i < 0 || i > 65535) {
                    valid = false;
                    errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
                }
            }
            catch (NumberFormatException numberFormatException) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
            }
            catch (Exception exception) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
            }
            if (valid && (iValue = new Integer(value)) != ZendDebuggerConfigurationDialog.this.originalPort && !AbstractDebuggerCommunicationDaemon.isPortAvailable(iValue)) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_portInUse;
            }
            ZendDebuggerConfigurationDialog.this.setErrorMessage(errorMessage);
            Button bt = ZendDebuggerConfigurationDialog.this.getButton(0);
            if (bt != null) {
                bt.setEnabled(valid);
            }
        }
    }
}

